/*
 * json_utils.h
 *
 *  
 *      
 */

#ifndef JSON_UTILS_H
#define JSON_UTILS_H

class json_utils {
public:
    json_utils();
    ~json_utils();

	//ApplicationHeader: File Header JSON object names
    static const char* APPLICATIONHEADER;

// //////////////////////////////////////////////////////////////////////
// Json object names used as keys to access json data
// //////////////////////////////////////////////////////////////////////

// for logging message as JSON string

	static const char* LOG_MESSAGE_messageId;
	static const char* LOG_MESSAGE_type;

	static const char* LOG_MESSAGE_application;
	static const char* LOG_MESSAGE_domain;
	static const char* LOG_MESSAGE_intent;
	static const char* LOG_MESSAGE_subID;
	static const char* LOG_MESSAGE_vehicleIdentifier;
	static const char* LOG_MESSAGE_userIdentifier;
	static const char* LOG_MESSAGE_languageID;
	static const char* LOG_MESSAGE_additionalJSONData;
	static const char* LOG_MESSAGE_messagetext;


// for message storage

	static const char* MSG_STORAGE_Message;
	static const char* MSG_STORAGE_metaDomain;
	static const char* MSG_STORAGE_Application;
	static const char* MSG_STORAGE_Domain;
	static const char* MSG_STORAGE_intent;
	static const char* MSG_STORAGE_subID;

	static const char* MSG_STORAGE_heroImageData_imageData;
	static const char* MSG_STORAGE_heroImageData_imageType;
	static const char* MSG_STORAGE_agentIconData_imageData;
	static const char* MSG_STORAGE_agentIconData_imageType;
	static const char* MSG_STORAGE_intentIconData_imageData;
	static const char* MSG_STORAGE_intentIconData_imageType;

	static const char* MSG_STORAGE_messagetext;
	static const char* MSG_STORAGE_additionalJSONData;
	static const char* MSG_STORAGE_lifetime_lifetimeMode;
	static const char* MSG_STORAGE_lifetime_exactLifeTimeSeconds;
	static const char* MSG_STORAGE_vehicleIdentifier;
	static const char* MSG_STORAGE_userProfileIdentifier;
	static const char* MSG_STORAGE_languageCode;
	static const char* MSG_STORAGE_languageID;
	static const char* MSG_STORAGE_networkRequestedForAction;
	static const char* MSG_STORAGE_muteButtonInPopup;

	static const char* MSG_STORAGE_Actions;
	static const char* MSG_STORAGE_additionalActionDataJSON;
	static const char* MSG_STORAGE_buttonText;

	static const char* MSG_STORAGE_Version;


// for settings

	static const char* SETTINGS_Settings;
	static const char* SETTINGS_UserId;
	static const char* SETTINGS_Domains;
	static const char* SETTINGS_ApplicationFlags;
	static const char* SETTINGS_Application;
	static const char* SETTINGS_Enabled;

	static const char* SETTINGS_GlobalSettings;
	static const char* SETTINGS_CenterStackListSize;
	static const char* SETTINGS_DefaultLifetime;
	static const char* SETTINGS_LowPriorityValue;
	static const char* SETTINGS_AntiFlickeringValue;
	static const char* SETTINGS_PopupStackSize;

	static const char* SETTINGS_Version;


// for statistics

	static const char* STATISTICS_Application;
	static const char* STATISTICS_Domain;
	static const char* STATISTICS_Intent;
	static const char* STATISTICS_Action;
	static const char* STATISTICS_Actions;
	static const char* STATISTICS_Response;
	static const char* STATISTICS_Responses;
	static const char* STATISTICS_ActionResponse;
	static const char* STATISTICS_ActionResponses;
	static const char* STATISTICS_Count;

	static const char* STATISTICS_AllMessages;
	static const char* STATISTICS_LastMessages;

	static const char* STATISTICS_Version;


// for file storage

	static const char* STORAGE_data;
	static const char* STORAGE_timestamp;
	static const char* STORAGE_year;
	static const char* STORAGE_month;
	static const char* STORAGE_day;
	static const char* STORAGE_hour;
	static const char* STORAGE_min;
	static const char* STORAGE_sec;
	static const char* STORAGE_DST;


// for rules

	static const char* RULES_Rules;

	static const char* RULES_Application;
	static const char* RULES_Applications;
	static const char* RULES_Deactivatable;
	static const char* RULES_Domain;
	static const char* RULES_Domains;
	static const char* RULES_Intent;
	static const char* RULES_Intents;

	static const char* RULES_Name;
	static const char* RULES_Icon;
	static const char* RULES_defaultIntentIcon;
	static const char* RULES_intentIcon;

	static const char* RULES_Prios;
	static const char* RULES_drivingPriority;
	static const char* RULES_notDrivingPriority;
	static const char* RULES_postDrivePriority;
	static const char* RULES_preDrivePriority;

	static const char* RULES_Base;
	static const char* RULES_Version;


// for profile identifier

	static const char* PROFILEID_kid;
	static const char* PROFILEID_pid;


// for action type

    static const char* ACTION_type;


// for action handler

	static const char* ACTIONHANDLER_type;

	static const char* ACTIONHANDLER_address;
	static const char* ACTIONHANDLER_countryName;
	static const char* ACTIONHANDLER_locality;
	static const char* ACTIONHANDLER_postalCode;
	static const char* ACTIONHANDLER_addressLines;

	static const char* ACTIONHANDLER_freeTextAddress;

	static const char* ACTIONHANDLER_gpsLocation; 
	static const char* ACTIONHANDLER_coordinates;
	static const char* ACTIONHANDLER_latitude;
	static const char* ACTIONHANDLER_longitude;

	static const char* ACTIONHANDLER_category;

	static const char* ACTIONHANDLER_WayPoints;
	static const char* ACTIONHANDLER_indexWaypoint;
	static const char* ACTIONHANDLER_location;

	static const char* ACTIONHANDLER_number;
	static const char* ACTIONHANDLER_text;


// for MQTT client

	static const char* MQTTCLIENT_type;

	static const char* MQTTCLIENT_ApplicationHeader;
	static const char* MQTTCLIENT_ApplicationData;

	static const char* MQTTCLIENT_UploadFunctionID;
	static const char* MQTTCLIENT_UserId;
	static const char* MQTTCLIENT_Token;
	static const char* MQTTCLIENT_CorrelationId;

	static const char* MQTTCLIENT_PushMessageFeedback_Data_feedback;
	static const char* MQTTCLIENT_PushMessageFeedback_Data_information;
	static const char* MQTTCLIENT_PushMessageFeedback_Data_messageIdentifier;
	static const char* MQTTCLIENT_TimeStamp;

	static const char* MQTTCLIENT_PushMessageDelete_Data_messageIdentifier;
	static const char* MQTTCLIENT_pmdmi;

	static const char* MQTTCLIENT_applicationIdentifier;

};

#endif /* JSON_UTILS_H */
